using System;
using System.Windows.Forms;

using System.Diagnostics;

namespace gov.va.med.vbecs.GUI.controls
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/20/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion


    public class VbecsFunction
    {
        private VbecsFunction()
        {
        }
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/20/2002</CreationDate>
		///
        /// <summary>
        /// Sets column widths on <see cref="ListView"/> to match either data, header, or 
        /// if no items are present, sets the column to zero width.
        /// </summary>
        /// <param name="listView"><see cref="ListView"/> to set column widths for.</param>
        public static void SetColumnWidths( ListView listView )
        {
			int _autoSizeToColumnHeaderWidth = -2;

            foreach( ColumnHeader _columnHeader in listView.Columns ) 
            {
				if( listView.Items.Count <= 0 || _columnHeader.Index == 0 )
				{
					_columnHeader.Width = _autoSizeToColumnHeaderWidth;
					continue;
				}

                _columnHeader.Width = 0;

                foreach( ListViewItem _listViewItem in listView.Items ) 
                {
					if( _columnHeader.Index >= _listViewItem.SubItems.Count )
						continue;

					if( _listViewItem.SubItems[ _columnHeader.Index ].Text.Length > 0 )
					{
						_columnHeader.Width = _autoSizeToColumnHeaderWidth;
						break;
					}
                }
            }
        }
    }
}
